<?php
use WHMCS\Database\Capsule;
session_start();
$module_version = "1.0";

function ol_domain_pricing_config() {
    global $module_version;
    $configarray = array(
        "name" => "OnlineNIC Quick Pricing Importer",
        "description" => "This module allows you quickly update domain selling price in bulk by multiply a factor or add a fix amount to the cost. ",
        "version" => $module_version,
        "author" => "OnlineNIC",
        "language" => "english",
        "fields" => array("username" => array ("FriendlyName" => "Admin username", "Type" => "text", "Size" => "30", "Description" => "[REQUIRED]", "Default" => "admin",))
    );
    return $configarray;
}

function ol_domain_pricing_activate() {
	return array('status'=>'success','description'=>'Installed');
}

function ol_domain_pricing_deactivate() {
	return array('status'=>'success','description'=>'Uninstalled');
}


function ol_domain_pricing_output($vars){
    //load and check if registrar module is installed
    require_once(dirname(__FILE__)."/../../../includes/registrarfunctions.php");
    //check if the registrar module exists
    $file = "ispapi";
    //check authentication
    $registrarconfigoptions = getregistrarconfigoptions($file);
    $ispapi_config = onlinenic_config($registrarconfigoptions);

    //download a sample csv file
    if(isset($_POST['download-sample-csv'])){
        download_csv_sample_file_ol();
    }

    //smarty template
    $smarty = new Smarty;
    $smarty->compile_dir = $GLOBALS['templates_compiledir'];
    $smarty->caching = false;
    $entity = ($ispapi_config["entity"] == "54cd") ? "PRODUCTION Environment" : "OT&E Environment";
    $smarty->assign('user', $ispapi_config["login"]);
    $smarty->assign('entity', $entity);

    //get all user classes
    $registrarconfigoptions = getregistrarconfigoptions($file);
    $ispapi_config = onlinenic_config($registrarconfigoptions);
    $command = array(
        "command" => "queryuserclasslist"
    );
    $queryuserclasslist = onlinenic_call($command, $ispapi_config);
    $smarty->assign('queryuserclasslist', $queryuserclasslist);

    if(isset($_POST['btn-to-step3']) || isset($_POST['optionSearch']) || isset($_POST['downloadCSV']) || isset($_POST['import'])){
        //step 3
        if(!isset($_POST['checkbox-tld']) && !isset($_POST['allData'])){
            echo "<div class='errorbox'><strong><span class='title'>File error!</span></strong><br>Please select at least one .</div>";
            $smarty->display(dirname(__FILE__).'/templates/step1.tpl');
            exit();
        }

        if(isset($_POST['checkData']))
            $checkData = json_decode(htmlspecialchars_decode($_POST['checkData']));
        $data = json_decode(htmlspecialchars_decode($_POST['allData']));
        if(isset($_POST['optionSearch'])){
            if($_POST['usingFactor'] != "") $factor = $_POST['usingFactor']; else $factor = 1;
            if($_POST['fixedDecimal'] != "omitted") $decimal = true; else $decimal = false;
            if($_POST['fixedAmount'] != "") $amount = $_POST['fixedAmount']; else $amount = 0;
            $rs = array();
            foreach ($data as $key => $val){
                if(!in_array($key,$checkData)){
                    array_push($rs,$val);
                    continue;
                }
                $tmp = array();
                foreach ($val as $v){
                    if(is_numeric($v)){
                        $v = round($v * $factor,2);
                        $v += $amount;
                        if($decimal)
                            $v = substr_replace($v,"9",strlen($v)-1);
                    }
                    array_push($tmp,$v);
                }
                array_push($rs,$tmp);
            }
            $smarty->assign('csv_as_new_array', $rs);
            $smarty->display(dirname(__FILE__).'/templates/step3.tpl');
        }else if (isset($_POST['downloadCSV'])){
            $csv_header = array('domain','type','1 year','2 years','3 years','4 years','5 years','6 years','7 years','8 years','9 years','10 years');
            csv_export($data,$csv_header,"OnlineNIC_domain_pricing");
        }else if (isset($_POST['import'])){
            //import domain pricing to db
            $pdo = Capsule::connection()->getPdo();
            $chkArr = array();
            $sign = true;
            foreach ($data as $val){
                $ext = $val[0];
                $type = $val[1];
                foreach($val as $k => $v){
                    if(trim($v) == "")
                        $val[$k] = "-1";
                }
                if(!in_array($ext,$chkArr)){
                    array_push($chkArr,$ext);
                    //tbldomainpricing table related operations
                    $stmt = $pdo->prepare("SELECT count(*) AS num FROM tbldomainpricing WHERE extension=?");
                    $stmt->execute(array($ext));
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    try {
                        if ($result['num'] == 0) {
                            $ins_stmt = $pdo->prepare("INSERT INTO tbldomainpricing ( extension, dnsmanagement, emailforwarding, idprotection, eppcode, autoreg, created_at) VALUES ( ?, ?, ?, ?, ?, 'onlinenic', ?)");
                            $ins_stmt->execute(array($ext, 0, 0, $_SESSION['idProtection'], $_SESSION['eppCode'], date("Y-m-d H:i:s")));
                            $sign = false;
                        } else {
                            $upd_stmt = $pdo->prepare("UPDATE tbldomainpricing SET idprotection=?,eppcode=?,autoreg='onlinenic',updated_at=? WHERE extension=?");
                            $upd_stmt->execute(array($_SESSION['idProtection'], $_SESSION['eppCode'], date("Y-m-d H:i:s"), $ext));
                            $sign = true;
                        }
                    }catch(Exception $e){
                        die($e->getMessage());
                    }
                }
                //tblpricing table related operations
                $stmt = $pdo->prepare("SELECT id FROM tbldomainpricing WHERE extension=?");
                $stmt->execute(array($ext));
                $tbldomainpricing = $stmt->fetch(PDO::FETCH_ASSOC);
                try {
                    if (!$sign) {
                        $insert_stmt = $pdo->prepare("INSERT INTO tblpricing (type, currency, relid, msetupfee, qsetupfee, ssetupfee, asetupfee, bsetupfee, monthly, quarterly, semiannually, annually, biennially) VALUES (?, '1', ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        $insert_stmt->execute(array($type, $tbldomainpricing['id'], $val[2], $val[3], $val[4], $val[5], $val[6], $val[7], $val[8], $val[9], $val[10], $val[11]));
                    } else {
                        $chk_stmt = $pdo->prepare("SELECT count(*) AS num FROM tblpricing WHERE relid=? and type=?");
                        $chk_stmt->execute(array($tbldomainpricing['id'], $type));
                        $checkResult = $chk_stmt->fetch(PDO::FETCH_ASSOC);
                        if ($checkResult['num'] == 0) {
                            $insert_stmt = $pdo->prepare("INSERT INTO tblpricing (type, currency, relid, msetupfee, qsetupfee, ssetupfee, asetupfee, bsetupfee, monthly, quarterly, semiannually, annually, biennially) VALUES (?, '1', ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                            $insert_stmt->execute(array($type, $tbldomainpricing['id'], $val[2], $val[3], $val[4], $val[5], $val[6], $val[7], $val[8], $val[9], $val[10], $val[11]));
                        } else {
                            $update_stmt = $pdo->prepare("UPDATE tblpricing  SET currency=1,msetupfee=?,qsetupfee=?,ssetupfee=?,asetupfee=?,bsetupfee=?,monthly=?,quarterly=?,semiannually=?,annually=?,biennially=?
                               WHERE relid=? and type=?");
                            $update_stmt->execute(array($val[2], $val[3], $val[4], $val[5], $val[6], $val[7], $val[8], $val[9], $val[10], $val[11], $tbldomainpricing['id'], $type));
                        }
                    }

                }catch (Exception $e) {
                    die($e->getMessage());
                }
            }
            $smarty->display(dirname(__FILE__).'/templates/step4.tpl');
        }else{
            if(isset($_POST['idProtection']) && $_POST['idProtection'] == 'idProtection') $_SESSION['idProtection'] = 1; else $_SESSION['idProtection'] = 0;
            if(isset($_POST['eppCode']) && $_POST['eppCode'] == 'eppCode') $_SESSION['eppCode'] = 1; else $_SESSION['eppCode'] = 0;
            $smarty->assign('csv_as_new_array', $data);
            $smarty->display(dirname(__FILE__).'/templates/step3.tpl');
        }
    }elseif(isset($_POST['price_class'])){
        //step 2
        $_SESSION["price_class"] = $_POST['price_class'];
        if($_POST['price_class'] == "CSV-FILE"){
            //when csv file is slected also in STEP 2
            //to check if the file is csv
            $type_of_uploaded_file = array('text/csv','application/vnd.ms-excel');
            if (isset($_FILES["file"])) {
                 if(in_array($_FILES["file"]["type"], $type_of_uploaded_file)){
                     $smarty->assign('post-file', $_FILES["file"]);
                     if($_FILES["file"]["name"] != "") {
                         $smarty->assign('post-file-name', $_FILES["file"]["name"]);
                         $tmpName = $_FILES['file']['tmp_name'];
                         $csvAsArray = array();
                         //if the delimiter is ; then continue else print an error message
                         if(checkDelimiterCount_ol($tmpName)){
                             //handling comma and semicolon with csv files
                             $csvAsArray = array_map(function($d) {
                                 return str_getcsv($d, ",");
                             }, file($tmpName));
                             //remove first element (header part of the csv file)
                             array_shift($csvAsArray);
                             $_SESSION["step2_data"] = $csvAsArray;
                             $smarty->assign('csv_as_new_array', $csvAsArray);
                             $smarty->display(dirname(__FILE__).'/templates/step2.tpl');
                         }else{
                             echo "<div class='errorbox'><strong><span class='title'>File error!</span></strong><br>CSV file format error.</div>";
                             $smarty->display(dirname(__FILE__).'/templates/step1.tpl');
                         }
                     }// end of if $_FILES["file"]["name"] is not empty
                     else{
                         echo "<div class='errorbox'><strong><span class='title'>ERROR!</span></strong><br>No CSV file has been selected.</div><br>";
                         $smarty->display(dirname(__FILE__).'/templates/step1.tpl');
                     }
                 }else{
                     echo "<div class='errorbox'><strong><span class='title'>ERROR!</span></strong><br>Please upload only a CSV file.</div><br>";
                     $smarty->display(dirname(__FILE__).'/templates/step1.tpl');
                 }

            }elseif(isset($_SESSION["csv-as-new-array"])){
                $csv_as_new_array = $_SESSION["csv-as-new-array"];
                $smarty->assign('csv_as_new_array', $csv_as_new_array);
                $smarty->display(dirname(__FILE__).'/templates/step2.tpl');
            }
        }else{
            echo "<div class='errorbox'><strong><span class='title'>ERROR!</span></strong><br>Something error has occurred.</div><br>";
            $smarty->display(dirname(__FILE__).'/templates/step1.tpl');
        }
    }elseif(isset($_POST['btn-to-step2'])){
        $data = $_SESSION["step2_data"];
        $smarty->assign('csv_as_new_array', $data);
        $smarty->display(dirname(__FILE__).'/templates/step2.tpl');
    }else{
        //step 1
        $smarty->assign('queryuserclasslist_PROPERTY_USERCLASS', $queryuserclasslist["PROPERTY"]["USERCLASS"]);
        $smarty->display(dirname(__FILE__).'/templates/step1.tpl');
    }

    //import button clicked
    if(isset($_POST['import'])){
        importButton_ol();
        $smarty->assign('post-import', $_POST['import']);
    }
}//end of ol_domain_pricing_output()

//download CSV
function csv_export(&$data, $titleList = array(), $fileName = '')
{
    ini_set("max_execution_time", "3600");
    $csvData = '';

    // title
    $nums = count($titleList);
    for ($i = 0; $i < $nums - 1; $i++)
    {
        $csvData .= '"' . $titleList[$i] . '",';
    }
    $csvData .= '"' . $titleList[$nums - 1] . "\"\r\n";

    foreach ($data as $key => $row)
    {
        $i = 0;
        $length = count($row);
        foreach ($row as $_key => $_val)
        {
            $_val = str_replace("\"", "\"\"", $_val);
            if ($i < ($length - 1))
            {
                $csvData .= '"' . $_val . '",';
            }
            elseif ($i == ($length - 1))
            {

                $csvData .= '"' . $_val . "\"\r\n";
            }
            $i++;
        }
        unset($data[$key]);
    }

    $csvData = mb_convert_encoding($csvData, "cp936", "UTF-8");
    $fileName = empty($fileName) ? date('Y-m-d-H-i-s', time()) : $fileName;
    $fileName = $fileName . '.csv';
    header("Content-type:text/csv;charset=utf-8");
    header("Content-Disposition:attachment;filename=" . $fileName);
    header('Cache-Control:must-revalidate,post-check=0,pre-check=0');
    header('Expires:0');
    header('Pragma:public');
    echo $csvData;
    die();
}

//to check if each line with semicolon separated
function checkDelimiterCount_ol($file){
    $file = new SplFileObject($file);
    $file->setFlags(SplFileObject::READ_CSV |
    SplFileObject::SKIP_EMPTY |
    SplFileObject::READ_AHEAD);
    $delimiter = ",";
    $count = 0;
    while (!$file->eof()) {
        $line = $file->fgets();
        if(!empty($line)){
            if(substr_count($line, $delimiter) > 11){
                $file = null;
                return 0;
            }
        }
        $count++;
    }
    $file = null;
    return 1;
}

//Import button clicked
//It collects the tlds and the updated prices by user. calls the startimport_ol()
function importButton_ol(){
    $prices_match_pattern = "/PRICE_(.*)_(.*)/";

    $tld_match = []; //has all the tld names which have new prices
    foreach($_POST as $key=>$value){
        if(preg_match($prices_match_pattern,$key,$match)){
          $tld_match[] = $match[1];
        }
    }
    //replace underscores with dots in the tlds
    foreach ($tld_match as $key => $value){
        $tld_match[$key] = strtolower(str_replace('_', '.', $value));
    }
    //for prices renew, register, transfer
    $price_name_match = []; //has all new prices (strings)
    foreach($_POST as $key=>$value){
        if(preg_match($prices_match_pattern,$key,$match)){
          $price_name_match[] = $match[2];
        }
    }
    $tld_new_price = [];
    foreach($_POST as $key=>$value){
        if(preg_match($prices_match_pattern, $key)){
          $tld_new_price[] = $value;
        }
    }
    $new_prices_for_whmcs = array_combine_ol($tld_match, $tld_new_price);

    //for checked items -DNS Management, email Forwarding, id Protection, epp code
    $domain_addons = [];

    // $domain_addons['dns-management'] ='';
    // $domain_addons['email-forwarding']='';
    // $domain_addons['id-protection'] = '';
    // $domain_addons['epp-code']= '';


    $dns_pattern = "/dns_management/";
    foreach($_POST as $key=>$value){
        if(preg_match($dns_pattern, $key)){
          $domain_addons['dns-management'] = $value;
        }
    }
    $emailforwarding_pattern = "/email_forwarding/";
    foreach($_POST as $key=>$value){
        if(preg_match($emailforwarding_pattern, $key)){
          $domain_addons['email-forwarding'] = $value;
        }
    }
    $idprotection_pattern = "/id_protection/";
    foreach($_POST as $key=>$value){
        if(preg_match($idprotection_pattern, $key)){
          $domain_addons['id-protection'] = $value;
        }
    }
    $eppcode_pattern = "/epp_code/";
    foreach($_POST as $key=>$value){
        if(preg_match($eppcode_pattern, $key)){
          $domain_addons['epp-code'] = $value;
        }
    }
    //for currency
    $currencies = [];
    $currency_pattern = "/currency/";
    foreach($_POST as $key=>$value){
        if(preg_match($currency_pattern, $key)){
          $currencies['currency'] = $value;
        }
    }
    // values in $domain_addons array are -  [dns-management] => checked='checked' !!!
    foreach ($domain_addons as $key => $value) {
        $domain_addons[$key] = 1;
    }

    foreach($new_prices_for_whmcs as $key=>$value){
        array_push($new_prices_for_whmcs[$key], $domain_addons);
    }

    //to merge each curreny value from currencies array new_prices_for_whmcs
    $i = -1;
    foreach($new_prices_for_whmcs as $key=>$value){
        $i++;
        $new_prices_for_whmcs[$key]['currency'] = $currencies['currency'][$i];
    }
    //import the data
    startimport_ol($new_prices_for_whmcs);
}

//loop through array and insert or update the tld and prices for whmcs to DB
function startimport_ol($prices_for_whmcs){
    try {
        $pdo = Capsule::connection()->getPdo();

        $prices_for_whmcs = array_change_key_case($prices_for_whmcs, CASE_LOWER);
        foreach($prices_for_whmcs as $key=>$value){
            //with TLD/extension
            $stmt = $pdo->prepare("SELECT * FROM tbldomainpricing WHERE extension=?");
            $stmt->execute(array('.'.$key));
            $tbldomainpricing = $stmt->fetch(PDO::FETCH_ASSOC);

            if(!empty($tbldomainpricing)){
                $update_stmt = $pdo->prepare("UPDATE tbldomainpricing SET dnsmanagement=?, emailforwarding=?, idprotection=?, eppcode=? WHERE extension=?");
                $update_stmt->execute(array($prices_for_whmcs[$key][3]['dns-management'], $prices_for_whmcs[$key][3]['email-forwarding'], $prices_for_whmcs[$key][3]['id-protection'], $prices_for_whmcs[$key][3]['epp-code'], '.'.$key));
            }else{
                if(!$prices_for_whmcs[$key][3]['dns-management']){
                    $prices_for_whmcs[$key][3]['dns-management'] = '';
                }
                if(!$prices_for_whmcs[$key][3]['email-forwarding']){
                    $prices_for_whmcs[$key][3]['email-forwarding'] = '';
                }
                if(!$prices_for_whmcs[$key][3]['id-protection']){
                    $prices_for_whmcs[$key][3]['id-protection'] = '';
                }
                if(!$prices_for_whmcs[$key][3]['epp-code']){
                    $prices_for_whmcs[$key][3]['epp-code'] = '';
                }

                $insert_stmt = $pdo->prepare("INSERT INTO tbldomainpricing ( extension, dnsmanagement, emailforwarding, idprotection, eppcode, autoreg) VALUES ( ?, ?, ?, ?, ?, 'ispapi')");
                $insert_stmt->execute(array('.'.$key, $prices_for_whmcs[$key][3]['dns-management'], $prices_for_whmcs[$key][3]['email-forwarding'], $prices_for_whmcs[$key][3]['id-protection'], $prices_for_whmcs[$key][3]['epp-code']));
                if($insert_stmt->rowCount() != 0){
                    $stmt = $pdo->prepare("SELECT id FROM tbldomainpricing WHERE extension=?");
                    $stmt->execute(array('.'.$key));
                    $tbldomainpricing = $stmt->fetch(PDO::FETCH_ASSOC);
                }
            }

            //replace or add pricing for domainregister
            $stmt = $pdo->prepare("SELECT * FROM tblpricing WHERE type='domainregister' AND currency=? AND relid=? ORDER BY id DESC LIMIT 1");
            $stmt->execute(array($prices_for_whmcs[$key]['currency'], $tbldomainpricing['id']));
            $tblpricing = $stmt->fetch(PDO::FETCH_ASSOC);
            if(!empty($tblpricing)){
                $update_stmt=$pdo->prepare("UPDATE tblpricing SET msetupfee=? WHERE id=?");
                $update_stmt->execute(array($prices_for_whmcs[$key][0], $tblpricing["id"]));
            }else{
                $insert_stmt = $pdo->prepare("INSERT INTO tblpricing (type, currency, relid, msetupfee, qsetupfee, ssetupfee, asetupfee, bsetupfee, monthly, quarterly, semiannually, annually, biennially) VALUES ('domainregister', ?, ?, ?, '-1', '-1', '-1', '-1', '-1', '-1', '-1', '-1', '-1')");
                $insert_stmt->execute(array($prices_for_whmcs[$key]['currency'], $tbldomainpricing['id'], $prices_for_whmcs[$key][0]));
            }

            //replace or add pricing for domainrenew
            $stmt = $pdo->prepare("SELECT * FROM tblpricing WHERE type='domainrenew' AND currency=? AND relid=? ORDER BY id DESC LIMIT 1");
            $stmt->execute(array($prices_for_whmcs[$key]['currency'], $tbldomainpricing['id']));
            $tblpricing = $stmt->fetch(PDO::FETCH_ASSOC);
            if(!empty($tblpricing)){
                $update_stmt=$pdo->prepare("UPDATE tblpricing SET msetupfee=? WHERE id=?");
                $update_stmt->execute(array($prices_for_whmcs[$key][1], $tblpricing["id"]));
            }else{
                $insert_stmt = $pdo->prepare("INSERT INTO tblpricing (type, currency, relid, msetupfee, qsetupfee, ssetupfee, asetupfee, bsetupfee, monthly, quarterly, semiannually, annually, biennially) VALUES ('domainrenew', ?, ?, ?, '-1', '-1', '-1', '-1', '-1', '-1', '-1', '-1', '-1')");
                $insert_stmt->execute(array($prices_for_whmcs[$key]['currency'], $tbldomainpricing['id'], $prices_for_whmcs[$key][1]));
            }

            //replace or add pricing for domaintransfer
            $stmt = $pdo->prepare("SELECT * FROM tblpricing WHERE type='domaintransfer' AND currency=? AND relid=? ORDER BY id DESC LIMIT 1");
            $stmt->execute(array($prices_for_whmcs[$key]['currency'], $tbldomainpricing['id']));
            $tblpricing = $stmt->fetch(PDO::FETCH_ASSOC);
            if(!empty($tblpricing)){
                $update_stmt=$pdo->prepare("UPDATE tblpricing SET msetupfee=? WHERE id=?");
                $update_stmt->execute(array($prices_for_whmcs[$key][2], $tblpricing["id"]));
            }else{
                $insert_stmt = $pdo->prepare("INSERT INTO tblpricing (type, currency, relid, msetupfee, qsetupfee, ssetupfee, asetupfee, bsetupfee, monthly, quarterly, semiannually, annually, biennially) VALUES ('domaintransfer', ?, ?, ?, '-1', '-1', '-1', '-1', '-1', '-1', '-1', '-1', '-1')");
                $insert_stmt->execute(array($prices_for_whmcs[$key]['currency'], $tbldomainpricing['id'], $prices_for_whmcs[$key][2]));
            }


        }

    } catch (Exception $e) {
        die($e->getMessage());
    }
}


//download a sample csv file
function download_csv_sample_file_ol(){
    // output headers so that the file is downloaded rather than displayed
    header('Content-type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=yourpricinglist.csv');
    // do not cache the file
    header('Pragma: no-cache');
    header('Expires: 0');
    //create a file pointer connected to the output stream
    $output = fopen('php://output', 'w');
    fputcsv($output, array('TLD','REGISTER_PRICE_USD','TRANSFER_PRICE_USD','RENEW_PRICE_USD'),";");
    fputcsv($output, array('com', '10.99', '10.99', '11.59'),";");
    fputcsv($output, array('com.au', '12.99', '10.45', '15.59'),";");
    exit(0);
}

//###### Helper functions ######
function array_combine_ol($keys, $values){
    $result = array();
    foreach ($keys as $i => $k) {
        $result[$k][] = $values[$i];
    }
    array_walk($result, create_function('&$v', '$v = (count($v) == 1)? array_pop($v): $v;'));
    return $result;
}

//filter tld data array for only tlds with usd currency
function filter_array_ol($array,$term){
    $matches = array();
    foreach($array as $key=>$value){
        if($value['currency'] == $term)
            $matches[$key]=$value;
    }
    return $matches;
}

function onlinenic_config($params) {
    $config = array();
    $config["registrar"] = $params["registrar"];
    $config["entity"] = "54cd";
    $config["url"] = "http://api.ispapi.net/api/call.cgi";
    $config["idns"] = $params["ConvertIDNs"];
    if ( $params["TestMode"] == 1 || $params["TestMode"] == "on" ) {
        $config["entity"] = "1234";
    }
    if ( $params["UseSSL"] == 1 || $params["UseSSL"] == "on" ) {
        $config["url"] = "https://coreapi.1api.net/api/call.cgi";
    }
    if ( strlen($params["ProxyServer"]) ) {
        $config["proxy"] = $params["ProxyServer"];
    }
    $config["login"] = $params["Username"];
    $config["password"] = $params["Password"];
    return $config;
}

function onlinenic_call($command, $config) {
    return ispapi_parse_response(ispapi_call_raw($command, $config));
}
function ispapi_call_raw($command, $config) {
    global $ispapi_module_version;
    $args = array();
    $url = $config["url"];
    if ( isset($config["login"]) )
        $args["s_login"] = $config["login"];
    if ( isset($config["password"]) )
        $args["s_pw"] = html_entity_decode($config["password"], ENT_QUOTES);
    if ( isset($config["user"]) )
        $args["s_user"] = $config["user"];
    if ( isset($config["entity"]) )
        $args["s_entity"] = $config["entity"];
    $args["s_command"] = ispapi_encode_command($command);

    # Convert IDNs via API
    if ( 1 ) {
        $new_command = array();
        foreach ( explode("\n", $args["s_command"]) as $line ) {
            if ( preg_match('/^([^\=]+)\=(.*)/', $line, $m) ) {
                $new_command[strtoupper(trim($m[1]))] = trim($m[2]);
            }
        }
        if ( strtoupper($new_command["COMMAND"]) != "CONVERTIDN" ) {
            $replace = array();
            $domains = array();
            foreach ( $new_command as $k => $v ) {
                if ( preg_match('/^(DOMAIN|NAMESERVER|DNSZONE)([0-9]*)$/i', $k) ) {
                    if ( preg_match('/[^a-z0-9\.\- ]/i', $v) ) {
                        $replace[] = $k;
                        $domains[] = $v;
                    }
                }
            }
            if ( count($replace) ) {
                if ( $config["idns"] == "PHP" ) {
                    foreach ( $replace as $index => $k ) {
                        $new_command[$k] = ispapi_to_punycode($new_command[$k]);
                    }
                }
                else {
                    $r = onlinenic_call(array("COMMAND" => "ConvertIDN", "DOMAIN" => $domains), $config);
                    if ( ($r["CODE"] == 200) && isset($r["PROPERTY"]["ACE"]) ) {
                        foreach ( $replace as $index => $k ) {
                            $new_command[$k] = $r["PROPERTY"]["ACE"][$index];
                        }
                        $args["s_command"] = ispapi_encode_command($new_command);
                    }
                }
            }
        }
    }

    $config["curl"] = curl_init($url);
    if ( $config["curl"] === FALSE ) {
        return "[RESPONSE]\nCODE=423\nAPI access error: curl_init failed\nEOF\n";
    }
    $postfields = array();
    foreach ( $args as $key => $value ) {
        $postfields[] = urlencode($key)."=".urlencode($value);
    }
    $postfields = implode('&', $postfields);
    curl_setopt( $config["curl"], CURLOPT_POST, 1 );
    curl_setopt( $config["curl"], CURLOPT_POSTFIELDS, $postfields );
    curl_setopt( $config["curl"], CURLOPT_HEADER, 0 );
    curl_setopt( $config["curl"], CURLOPT_RETURNTRANSFER , 1 );
    if ( strlen($config["proxy"]) ) {
        curl_setopt( $config["curl"], CURLOPT_PROXY, $config["proxy"] );
    }
    curl_setopt($config["curl"], CURLOPT_USERAGENT, "ISPAPI/$ispapi_module_version WHMCS/".$GLOBALS["CONFIG"]["Version"]." PHP/".phpversion()." (".php_uname("s").")");
    curl_setopt($config["curl"], CURLOPT_REFERER, $GLOBALS["CONFIG"]["SystemURL"]);
    $response = curl_exec($config["curl"]);

    if ( preg_match('/(^|\n)\s*COMMAND\s*=\s*([^\s]+)/i', $args["s_command"], $m) ) {
        $command = $m[2];
        // don't log read-only requests
        if ( !preg_match('/^(Check|Status|Query|Convert)/i', $command) ) {
            ispapi_logModuleCall($config["registrar"], $command, $args["s_command"], $response);
        }
    }

    return $response;
}
function  ispapi_encode_command( $commandarray ) {
    if (!is_array($commandarray)) return $commandarray;
    $command = "";
    foreach ( $commandarray as $k => $v ) {
        if ( is_array($v) ) {
            $v = ispapi_encode_command($v);
            $l = explode("\n", trim($v));
            foreach ( $l as $line ) {
                $command .= "$k$line\n";
            }
        }
        else {
            $v = preg_replace( "/\r|\n/", "", $v );
            $command .= "$k=$v\n";
        }
    }
    return $command;
}

function ispapi_to_punycode($domain) {
    if ( !strlen($domain) ) return $domain;
    if ( preg_match('/^[a-z0-9\.\-]+$/i', $domain) ) {
        return $domain;
    }

    $charset = $GLOBALS["CONFIG"]["Charset"];
    if ( function_exists("idn_to_ascii") ) {
        $punycode = idn_to_ascii($domain, $charset);
        if ( strlen($punycode) ) return $punycode;
    }
    return $domain;
}

function ispapi_parse_response ( $response ) {
    if (is_array($response)) return $response;
    $hash = array(
        "PROPERTY" => array(),
        "CODE" => "423",
        "DESCRIPTION" => "Empty response from API"
    );
    if (!$response) return $hash;
    $rlist = explode( "\n", $response );
    foreach ( $rlist as $item ) {
        if ( preg_match("/^([^\=]*[^\t\= ])[\t ]*=[\t ]*(.*)$/", $item, $m) ) {
            $attr = $m[1];
            $value = $m[2];
            $value = preg_replace( "/[\t ]*$/", "", $value );
            if ( preg_match( "/^property\[([^\]]*)\]/i", $attr, $m) ) {
                $prop = strtoupper($m[1]);
                $prop = preg_replace( "/\s/", "", $prop );
                if ( in_array($prop, array_keys($hash["PROPERTY"])) ) {
                    array_push($hash["PROPERTY"][$prop], $value);
                }
                else {
                    $hash["PROPERTY"][$prop] = array($value);
                }
            }
            else {
                $hash[strtoupper($attr)] = $value;
            }
        }
    }
    if ( (!$hash["CODE"]) || (!$hash["DESCRIPTION"]) ) {
        $hash = array(
            "PROPERTY" => array(),
            "CODE" => "423",
            "DESCRIPTION" => "Invalid response from API"
        );
    }
    return $hash;
}
?>
